/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.MemoryMap;
import jpcsp.graphics.VideoEngine;
import jpcsp.memory.DebuggerMemory;
import jpcsp.memory.DirectBufferMemory;
import jpcsp.memory.FastMemory;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.memory.NativeMemory;
import jpcsp.memory.SafeDirectBufferMemory;
import jpcsp.memory.SafeFastMemory;
import jpcsp.memory.SafeNativeMemory;
import jpcsp.memory.SafeSparseNativeMemory;
import jpcsp.memory.SparseNativeMemory;
import jpcsp.memory.StandardMemory;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.Settings;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public abstract class Memory
implements IState {
    public static Logger log = Logger.getLogger((String)"memory");
    private static Memory instance = null;
    public static boolean useNativeMemory = false;
    public static boolean useDirectBufferMemory = false;
    public static boolean useSafeMemory = true;
    public static final int addressMask = 0x1FFFFFFF;
    private boolean ignoreInvalidMemoryAccess = false;
    protected static final int MEMORY_PAGE_SHIFT = 12;
    protected static final boolean[] validMemoryPage = new boolean[0x100000];
    private static final int MINIMUM_LENGTH_FOR_VIDEO_CHECK = 960;
    private static final int STATE_VERSION = 0;

    public static Memory getInstance() {
        if (instance == null) {
            boolean useDebuggerMemory = false;
            if (Settings.getInstance().readBool("emu.useDebuggerMemory") || new File(DebuggerMemory.mBrkFilePath).exists()) {
                useDebuggerMemory = true;
                useSafeMemory = true;
            }
            if (Settings.getInstance().readBool("emu.ignoreInvalidMemoryAccess") && !useDebuggerMemory) {
                useSafeMemory = false;
            }
            if (useNativeMemory) {
                try {
                    System.loadLibrary("memory");
                }
                catch (UnsatisfiedLinkError e) {
                    log.error((Object)"Cannot load memory library", (Throwable)e);
                    useNativeMemory = false;
                }
            }
            instance = useNativeMemory ? (useSafeMemory ? new SafeNativeMemory() : new NativeMemory()) : (useDirectBufferMemory ? (useSafeMemory ? new SafeDirectBufferMemory() : new DirectBufferMemory()) : (useSafeMemory ? new SafeFastMemory() : new FastMemory()));
            if (instance != null && !instance.allocate()) {
                instance = null;
                if (useNativeMemory && !(instance = useSafeMemory ? new SafeSparseNativeMemory() : new SparseNativeMemory()).allocate()) {
                    log.warn((Object)String.format("Cannot allocate native memory", new Object[0]));
                    instance = null;
                }
            }
            if (instance == null && !(instance = new StandardMemory()).allocate()) {
                instance = null;
            }
            if (instance == null) {
                throw new OutOfMemoryError("Cannot allocate memory");
            }
            if (useDebuggerMemory) {
                DebuggerMemory.install();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Using %s", instance.getClass().getName()));
            }
        }
        return instance;
    }

    protected Memory() {
        Settings.getInstance().registerSettingsListener("Memory", "emu.ignoreInvalidMemoryAccess", new IgnoreInvalidMemoryAccessSettingsListerner());
    }

    public static void setInstance(Memory mem) {
        instance = mem;
    }

    public void invalidMemoryAddress(int address, String prefix, int status) {
        String message = String.format("%s - Invalid memory address: 0x%08X PC=0x%08X", prefix, address, RuntimeContext.getPc());
        if (this.ignoreInvalidMemoryAccess) {
            log.warn((Object)("IGNORED: " + message));
        } else {
            if (Thread.currentThread().getName().startsWith("Dmac Thread for 0x")) {
                log.error((Object)message, new Throwable());
            } else {
                log.error((Object)message);
            }
            Emulator.PauseEmuWithStatus(status);
        }
    }

    public void invalidMemoryAddress(int address, int length, String prefix, int status) {
        String message = String.format("%s - Invalid memory address: 0x%08X-0x%08X(length=0x%X) PC=0x%08X", prefix, address, address + length, length, RuntimeContext.getPc());
        if (this.ignoreInvalidMemoryAccess) {
            log.warn((Object)("IGNORED: " + message));
        } else {
            log.error((Object)message);
            Emulator.PauseEmuWithStatus(status);
        }
    }

    public boolean read32AllowedInvalidAddress(int address) {
        if (address >= -1887436768 && address <= -1887436372 || address >= 260046880 && address <= 260047276) {
            log.debug((Object)"read32 - ignoring pspSdkInstallNoPlainModuleCheckPatch");
            return true;
        }
        return false;
    }

    public abstract void Initialise();

    public abstract int read8(int var1);

    public abstract int read16(int var1);

    public abstract int read32(int var1);

    public abstract void write8(int var1, byte var2);

    public abstract void write16(int var1, short var2);

    public abstract void write32(int var1, int var2);

    public abstract void memset(int var1, byte var2, int var3);

    public abstract Buffer getMainMemoryByteBuffer();

    public abstract Buffer getBuffer(int var1, int var2);

    public abstract void copyToMemory(int var1, ByteBuffer var2, int var3);

    protected abstract void memcpy(int var1, int var2, int var3, boolean var4);

    public boolean hasMemoryInt(int address) {
        return false;
    }

    public int[] getMemoryInt(int address) {
        return null;
    }

    public int getMemoryIntOffset(int address) {
        return (address & 0x1FFFFFFF) >> 2;
    }

    public static boolean isAddressGood(int address) {
        return validMemoryPage[address >>> 12];
    }

    public static boolean isAddressAlignedTo(int address, int alignment) {
        return address % alignment == 0;
    }

    public static boolean isRawAddressGood(int rawAddress) {
        return validMemoryPage[rawAddress >> 12];
    }

    public boolean allocate() {
        for (int i = 0; i < validMemoryPage.length; ++i) {
            int address = Memory.normalizeAddress(i << 12);
            boolean isValid = false;
            if (address >= 0x8000000 && address <= MemoryMap.END_RAM) {
                isValid = true;
            } else if (address >= 0x4000000 && address <= 0x41FFFFF) {
                isValid = true;
            } else if (address >= 65536 && address <= 81919) {
                isValid = true;
            }
            Memory.validMemoryPage[i] = isValid;
        }
        return true;
    }

    public int internalRead8(int address) {
        return this.read8(address);
    }

    public int internalRead16(int address) {
        return this.read16(address);
    }

    public int internalRead32(int address) {
        return this.read32(address);
    }

    public long read64(int address) {
        long low = this.read32(address);
        long high = this.read32(address + 4);
        return low & 0xFFFFFFFFL | high << 32;
    }

    public void write64(int address, long data) {
        this.write32(address, (int)data);
        this.write32(address + 4, (int)(data >> 32));
    }

    public void writeUnsigned16(int address, int data) {
        this.write16(address, (short)data);
    }

    public void memcpy(int destination, int source, int length) {
        this.memcpy(destination, source, length, false);
    }

    public void memcpyWithVideoCheck(int destination, int source, int length) {
        if (length >= 960) {
            if (Memory.isVRAM(destination) || Modules.sceDisplayModule.isFbAddress(destination)) {
                Modules.sceDisplayModule.waitForRenderingCompletion(destination);
                VideoEngine.getInstance().addVideoTexture(destination, source, length);
            }
            if (Memory.isVRAM(source) && Modules.sceDisplayModule.getSaveGEToTexture()) {
                VideoEngine.getInstance().addVideoTexture(source, source + length);
            }
            if (Memory.isVRAM(source)) {
                Modules.sceDisplayModule.waitForRenderingCompletion(source);
            }
        } else if (Memory.isVRAM(destination)) {
            Modules.sceDisplayModule.waitForRenderingCompletion(destination);
        }
        this.memcpy(destination, source, length);
    }

    public void memsetWithVideoCheck(int address, byte data, int length) {
        if (length >= 960) {
            if (Memory.isVRAM(address) || Modules.sceDisplayModule.isFbAddress(address)) {
                Modules.sceDisplayModule.waitForRenderingCompletion(address);
                VideoEngine.getInstance().addVideoTexture(address, address + length);
            }
        } else if (Memory.isVRAM(address)) {
            Modules.sceDisplayModule.waitForRenderingCompletion(address);
        }
        this.memset(address, data, length);
    }

    public void memmove(int destination, int source, int length) {
        this.memcpy(destination, source, length, true);
    }

    public int normalize(int address) {
        return address & 0x1FFFFFFF;
    }

    public static int normalizeAddress(int address) {
        if (((address &= 0x1FFFFFFF) & 0xFF000000) == 0x4000000) {
            address &= 0xFF1FFFFF;
        }
        return address;
    }

    protected boolean areOverlapping(int destination, int source, int length) {
        return source + length > destination && destination + length > source;
    }

    public boolean isIgnoreInvalidMemoryAccess() {
        return this.ignoreInvalidMemoryAccess;
    }

    public void setIgnoreInvalidMemoryAccess(boolean ignoreInvalidMemoryAccess) {
        this.ignoreInvalidMemoryAccess = ignoreInvalidMemoryAccess;
    }

    public static boolean isRAM(int address) {
        return (address &= 0x1FFFFFFF) >= 0x8000000 && address <= MemoryMap.END_RAM;
    }

    public static boolean isVRAM(int address) {
        return (address &= 0x1FFFFFFF) <= 0x41FFFFF && address >= 0x4000000;
    }

    public void remapMemoryAtProcessorReset() {
    }

    public void reset() {
    }

    protected void read(StateInputStream stream, int address, int length) throws IOException {
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(this, address, length, 4);
        for (int i = 0; i < length; i += 4) {
            memoryWriter.writeNext(stream.readInt());
        }
        memoryWriter.flush();
    }

    protected void write(StateOutputStream stream, int address, int length) throws IOException {
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(this, address, length, 4);
        for (int i = 0; i < length; i += 4) {
            stream.writeInt(memoryReader.readNext());
        }
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.read(stream, 65536, 16384);
        this.read(stream, 0x4000000, 0x200000);
        this.read(stream, 0x8000000, MemoryMap.SIZE_RAM);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        this.write(stream, 65536, 16384);
        this.write(stream, 0x4000000, 0x200000);
        this.write(stream, 0x8000000, MemoryMap.SIZE_RAM);
    }

    private class IgnoreInvalidMemoryAccessSettingsListerner
    extends AbstractBoolSettingsListener {
        private IgnoreInvalidMemoryAccessSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            Memory.this.setIgnoreInvalidMemoryAccess(value);
        }
    }
}

